//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
// stdafx.h : plik nagwkowy dla standardowych plikw nagwkowych
// lub plikw wykorzystywanych w konkretnych projektach. Takie pliki s czsto wykorzystywane,
// ale ich zawarto rzadko si zmienia.
//

// Jest to cz biblioteki Microsoft Foundation Classes C++.
// Copyright (c) Microsoft Corporation. Wszystkie prawa zastrzeone.
//
// Poniszy kod rdowy powsta tylko w celu uzupenienia
// Microsoft Foundation Classes Reference i powizanej
// dokumentacji elektronicznej, jaka zostaa udostpniona wraz z bibliotek.
// Szczegowe informacji na temat produktu Microsoft Foundation Classes
// mona odnale w tej dokumentacji.

#define VC_EXTRALEAN        // Wyczenie rzadko uywanych elementw z nagwkw Windows

#include <string>
#include <map>

#include <afxwin.h>         // Podstawowe i standardowe komponenty MFC
#include <afxext.h>         // Rozszerzenia MFC
#ifndef _AFX_NO_AFXCMN_SUPPORT
#include <afxcmn.h>         // Obsuga MFC dla Windows 95 Common Controls
#endif // _AFX_NO_AFXCMN_SUPPORT

#include "resource.h"

const int STRING_BUFFER_LEN = 256;

typedef const char * LPCUTF8;
typedef char *       LPUTF8;

#include "cor.h"
#include "CorError.h"

#define MakePtr( cast, ptr, addValue ) (cast)( (DWORD_PTR)(ptr) + (DWORD_PTR)(addValue))

#define GetImgDirEntryRVA( pNTHdr, IDE ) \
	(pNTHdr->OptionalHeader.DataDirectory[IDE].VirtualAddress)

typedef struct _META_STREAM_HEADER 
{
    DWORD Offset;  
    DWORD Size; 
	char Name[1];
} META_STREAM_HEADER, *PMETA_STREAM_HEADER;

typedef struct _META_COMPOSITE_HEADER 
{
    DWORD Reserved;  
    BYTE MajorVersion; 
    BYTE MinorVersion; 
    BYTE HeapSizes; 
    BYTE Padding;
	ULONGLONG Valid;
	ULONGLONG Sorted;
} META_COMPOSITE_HEADER, *PMETA_COMPOSITE_HEADER;

typedef enum TableType
{
	Module          = 0x00,
	TypeRef         = 0x01,
	TypeDef         = 0x02,
	FieldDef        = 0x04,
	MethodDef       = 0x06,
	ParamDef        = 0x08,
	InterfaceImpl   = 0x09,
	MemberRef       = 0x0a,
	Constant        = 0x0b,
	CustomAttribute = 0x0c,
	FieldMarshal	= 0x0d,
	DeclSecurity    = 0x0e,
	ClassLayout	    = 0x0f,
    StandAloneSig   = 0x11,
    EventMap        = 0x12,
    Event           = 0x14,
    PropertyMap     = 0x15,
    Property        = 0x17,
    MethodSemantics = 0x18,
    ModuleRef       = 0x1a,
    TypeSpec        = 0x1b,
    ImplMap         = 0x1c,
    FieldRVA        = 0x1d,
    Assembly        = 0x20,
    AssemblyProcessor = 0x21,
    AssemblyOS      = 0x22,
    AssemblyRef     = 0x23,
    AssemblyRefProcessor = 0x24,
    AssemblyRefOS   = 0x25,
    File            = 0x26,
    ExportedType    = 0x27,
    ManifestResource= 0x28,
    NestedClass     = 0x29,
    UserString      = 0x70,
	Unassigned      = -1
} TableType;

typedef struct _META_TABLE_ENTRY 
{
	_META_TABLE_ENTRY()
	{
		Table = Unassigned;
		Rows = 0;
		RowSize = 0;
		HeapSizes = 0;
		IndexSizes = 0;
		Address = NULL;
	}
	TableType Table;
	std::wstring Name;
	DWORD Rows;
	DWORD RowSize;
	PBYTE Address;
	BYTE HeapSizes;
	BYTE IndexSizes;
} META_TABLE_ENTRY, *PMETA_TABLE_ENTRY;


//================================================================================
//
// Wyszukanie nagwka sekcji zawierajcego RVA i zwrcenie wskanika
// do jego IMAGE_SECTION_HEADER
//
template <class T> PIMAGE_SECTION_HEADER GetEnclosingSectionHeader(DWORD rva, T* pNTHeader)	// 'T' == PIMAGE_NT_HEADERS 
{
    PIMAGE_SECTION_HEADER section = IMAGE_FIRST_SECTION(pNTHeader);
    unsigned i;
    
    for ( i=0; i < pNTHeader->FileHeader.NumberOfSections; i++, section++ )
    {
		// Ponisze trzy linie s wymagane, poniewa konsolidator Watcom ustawia
		// pole Misc.VirtualSize na 0.
		DWORD size = section->Misc.VirtualSize;
		if ( 0 == size )
			size = section->SizeOfRawData;
			
        // Czy RVA znajduje si w tej sekcji?
        if ( (rva >= section->VirtualAddress) && 
             (rva < (section->VirtualAddress + size)))
            return section;
    }
    
    return 0;
}

template <class T> LPVOID GetPtrFromRVA( DWORD rva, T* pNTHeader, PBYTE imageBase ) // 'T' = PIMAGE_NT_HEADERS 
{
	PIMAGE_SECTION_HEADER pSectionHdr;
	INT delta;
		
	pSectionHdr = GetEnclosingSectionHeader( rva, pNTHeader );
	if ( !pSectionHdr )
		return 0;

	delta = (INT)(pSectionHdr->VirtualAddress-pSectionHdr->PointerToRawData);
	return (PVOID) ( imageBase + rva - delta );
}

//
// Podobnie jak GetPtrFromRVA, ale dziaa z adresami, ktre ju obejmuj
// domyln podstaw obrazu.
//
template <class T> LPVOID GetPtrFromVA( PVOID ptr, T* pNTHeader, PBYTE pImageBase ) // 'T' = PIMAGE_NT_HEADERS 
{
	// Tak, w Win64 naprawd usuwane s grne 32 bity z wartoci 64-bitowej.
	// Zakadamy, i dwa wskaniki znajduj si w tym samym module, przez co
	// s one RVA.
	DWORD rva = PtrToLong( (PBYTE)ptr - pNTHeader->OptionalHeader.ImageBase );
	
	return GetPtrFromRVA( rva, pNTHeader, pImageBase );
}

//
// Wyszukanie nazwy sekcji w tablicy sekcji i zwrcenie wskanika
// do jej IMAGE_SECTION_HEADER
//
template <class T> PIMAGE_SECTION_HEADER GetSectionHeader(PSTR name, T* pNTHeader)	// 'T' == PIMAGE_NT_HEADERS
{
    PIMAGE_SECTION_HEADER section = IMAGE_FIRST_SECTION(pNTHeader);
    unsigned i;
    
    for ( i=0; i < pNTHeader->FileHeader.NumberOfSections; i++, section++ )
    {
        if ( 0 == strncmp((char *)section->Name,name,IMAGE_SIZEOF_SHORT_NAME) )
            return section;
    }
    
    return 0;
}

#include "AssemblyDoc.h"
#include "AssemblyFrame.h"
#include "BlobHeapPage.h"
#include "StringHeapPage.h"
#include "UserStringHeapPage.h"
#include "GUIDHeapPage.h"
#include "MetadataTablesPage.h"
#include "FileHeaderPropertiesPage.h"
#include "OptionalHeaderPropertiesPage.h"
#include "DataDirectoryPage.h"
#include "SectionPage.h"
#include "ImportPage.h"
#include "ImportAddressPage.h"
#include "CILHeaderPage.h"

#include "AssemblyView.h"
